<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowCategoryPage()
  ===================================================*/

  function ShowCategoryPage() {

    // vars global configuration
    global $dbConn, $theme_path, $number_of_links_format,
             $cat_default_image, $cat_columns, $max_sub_cat, $cat_link_style,
             $cat_path_link_style, $subcat_link_style, $cat_table_width,
             $cat_cellspacing, $max_rows, $category_separator, $theme_name,
             $cat_description_format, $site_url;

    // vars url & form
    global $cat, $pg_which;

    // vars messages
    global $msg;

    // vars template
    global $header, $footer, $category, $category_name, $category_description, 
             $link, $pagination, $category_path, $content, $editor, 
             $category_path_search_opt, $meta_keywords, $meta_description, 
             $page_title, $editors, $sponsored_link, $num_rows;

    $tpl = new Template();

    $category_obj = new clsCategory;
    $category_obj->table_name      = "idx_category";
    $category_obj->link_table_name = "idx_link";

    $page_title                    = $category_obj->GetPageTitle($cat);
    if (empty($page_title)) {
      $page_title = $msg["10011"] . $category_separator . $category_obj->GetCategoryPath($cat);
    }

    $header                        = $category_obj->GetHeader($cat);
    $footer                        = $category_obj->GetFooter($cat);
    $meta_keywords                 = $category_obj->GetMetaKeyword($cat);
    $meta_description              = $category_obj->GetMetaDescription($cat);
    $content                       = $category_obj->GetContent($cat);

    $category_obj->separator       = $category_separator;
    $category_obj->header          = $msg["10012"];
    $category_name                 = $category_obj->GetCategoryName($cat);
    $category_description          = $category_obj->GetCategoryDescription($cat);
    $category_path                 = $category_obj->GetCategoryPath($cat, TRUE);
    $category_path                 = "<a href=\"$site_url/\" style=\"$cat_path_link_style\">"
                                       . $msg["10011"] . "</a>"
                                       . $category_obj->separator
                                       . $category_path;
    $category_path_search_opt      = $category_obj->GetCategoryPath($cat);

    // show categories

    if ($pg_which == 1 || $pg_which == "") {
      $category_obj->number_of_columns      = $cat_columns;
      $category_obj->number_of_subcats      = $max_sub_cat;
      $category_obj->default_image          = $cat_default_image;
      $category_obj->image_path             = "themes/" . $theme_name . "/images/";
      $category_obj->show_description       = true;
      $category_obj->number_of_links_format = $number_of_links_format;
      $category_obj->cat_description_format = $cat_description_format;
      $category_obj->cat_link_style         = $cat_link_style;
      $category_obj->cat_table_width        = $cat_table_width;
      $category_obj->cat_cellspacing        = $cat_cellspacing;
      $category_obj->show_subcat            = false;
      $category_obj->parent                 = $cat;
      $category                             = $category_obj->Display();
    }

    // show links

    // exclude sponsored link
    $sp_expire = date('Y-m-d H:i:s');
    $query = "select link_id
              from idx_paid_listing where sponsored = 1 and expire > '$sp_expire'";
    $result = $dbConn->Execute($query);
    while (!$result->EOF) {
      $lid[] = $result->Fields('link_id');
      $result->MoveNext();
    }

    $links_obj = new clsLink;
    $links_obj->query = "
      select idx_link.*,
             if (isnull(premium) || expire < now() || paid != 1, 0, premium) premium
      from idx_link
           left join idx_paid_listing on (idx_link.link_id = idx_paid_listing.link_id)
           left join idx_pagerank on (idx_link.link_id = idx_pagerank.link_id)
      where (category_id = '$cat' or cat1 = '$cat' or cat2 = '$cat')
      and suspended = 0";

    while (list($k, $v) = @each($lid)) {
      $links_obj->query .= "  and idx_link.link_id <> '$v'";
    }
    @reset($lid);

    if ($_COOKIE['COOKIE_SORT_BY']) {
      $links_obj->query .= "  order by premium desc, $_COOKIE[COOKIE_SORT_BY] $_COOKIE[COOKIE_SORT_ORDER]";
    }
    else {
      $links_obj->query .= "  order by premium desc, bid desc";
    }

    $links_obj->table_name            = "idx_link";
    $links_obj->category_table_name   = "idx_category";
    $links_obj->user_table_name       = "idx_users";
    $links_obj->editor_table_name     = "idx_editor";
    $links_obj->template_file         = $theme_path . "rows.html";
    $links_obj->date_format           = $msg["10014"];
    $links_obj->rating_image_path     = "themes/" . $theme_name . "/images/rating/";
    $links_obj->rev_rating_image_path = "themes/" . $theme_name . "/images/review/";
    $links_obj->header                = $msg["10013"];
    $links_obj->paging                = true;
    $links_obj->pg_size               = $max_rows;
    $links_obj->href                  = "browse.php";
    $links_obj->more_param            = "&cat=$cat";
    $links_obj->category_file         = "browse.php";
    $links_obj->category_separator    = $category_separator;
    $links_obj->page_file             = "browse";                                         // for mod rewrite
    $links_obj->page_title            = strtolower($category_obj->GetCategoryName($cat)); // for mod rewrite
    $link                             = $links_obj->Display();
    $num_rows                         = $links_obj->record_count_of_display + @count($lid);
    $pagination                       = $links_obj->pagination;

    // display editors
    $editors                          = $links_obj->GetEditor($cat);

    if (@count($editors) > 0) {
      while (list(, $editor_username) = @each($editors)) {
        $editor_str .= "<a href=user_detail.php?u=$editor_username style='color:black; font-weight: normal;'>$editor_username</a> ";
      }
      $tpl->assign('editors', $editor_str);
      $editor = $tpl->fetch('var:' . $msg["10015"]);
    }

    // display sponsored_link
    $query = "select * from idx_link where (0!= 0 ";
    while(list(, $v) = @each($lid)) {
      $query .= "or link_id = '$v' ";
    }
    $query .= " ) and (category_id = '$cat' or cat1 = '$cat' or cat2 = '$cat')
                 and suspended = 0";

    $links_obj->query         = $query;
    $links_obj->header        = $msg["10016"];
    $links_obj->template_file = $theme_path . "rows.html";
    $pg_which                 = 1; // remove this line if you want to show in first page only
    $sponsored_link           = $links_obj->Display();

    DisplayTemplate($theme_path . "browse.html",
      "\$header,\$footer,\$category_path,\$category_path_search_opt,".
      "\$category,\$category_name,\$category_description,\$meta_keywords,".
      "\$meta_description,\$page_title,\$editors,\$header,\$footer,\$num_rows,".
      "\$pagination,\$cat,\$link,\$content,\$start_number,\$ma,\$editor,".
      "\$sponsored_link");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  AddFilter("page_cache");
  RunPreFilter(__FILE__);

  if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    RemoveFilter("page_cache");
    setcookie("COOKIE_SORT_BY", $_POST['sort_by'], 0, "/",  "", 0);
    setcookie("COOKIE_SORT_ORDER", $_POST['sort_order'], 0, "/",  "", 0);
    Redirect($_SERVER['REQUEST_URI']);
  }

  if (!defined('CACHED_PAGE')) {
    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->separator  = $category_separator;
    if (!$cat) {
      list($cat, $pg_which) = $category_obj->ParseCategoryPath();
      if (!$cat) {
        RemoveFilter('page_cache');
        header("HTTP/1.0 404 Not Found");
        $requested_url = $_SERVER["REQUEST_URI"];
        DisplayTemplate($theme_path . "404.html", "\$requested_url");
        RunPostFilter(__FILE__);
      }
    }

    if ($category_obj->GetAccessPermission($cat) == 1) {
      RemoveFilter("page_cache");
      ExecuteFilter("validate_user");
    }

    ShowCategoryPage();
  }

  RunPostFilter(__FILE__);

?>